/*****************************************************************************
 * vlc.h: global header for vlc
 *****************************************************************************
 * Copyright (C) 1998, 1999, 2000 VideoLAN
 * $Id: vlc.h,v 1.28 2003/12/02 12:57:35 gbazin Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#ifndef _VLC_VLC_H
#define _VLC_VLC_H 1

# ifdef __cplusplus
extern "C" {
# endif

/*****************************************************************************
 * Our custom types
 *****************************************************************************/
typedef int vlc_bool_t;
typedef struct vlc_list_t vlc_list_t;
typedef struct vlc_object_t vlc_object_t;

typedef union
{
    int             i_int;
    vlc_bool_t      b_bool;
    float           f_float;
    char *          psz_string;
    void *          p_address;
    vlc_object_t *  p_object;
    vlc_list_t *    p_list;

#if defined( WIN32 ) && !defined( __MINGW32__ )
    signed __int64   i_time;
# else
    signed long long i_time;
#endif

    struct { char *psz_name; int i_object_id; } var;

   /* Make sure the structure is at least 64bits */
    struct { char a, b, c, d, e, f, g, h; } padding;

} vlc_value_t;

struct vlc_list_t
{
    int             i_count;
    vlc_value_t *   p_values;
    int *           pi_types;

};

/*****************************************************************************
 * Error values
 *****************************************************************************/
#define VLC_SUCCESS         -0                                   /* No error */
#define VLC_ENOMEM          -1                          /* Not enough memory */
#define VLC_ETHREAD         -2                               /* Thread error */
#define VLC_ETIMEOUT        -3                                    /* Timeout */

#define VLC_ENOMOD         -10                           /* Module not found */

#define VLC_ENOOBJ         -20                           /* Object not found */
#define VLC_EBADOBJ        -21                            /* Bad object type */

#define VLC_ENOVAR         -30                         /* Variable not found */
#define VLC_EBADVAR        -31                         /* Bad variable value */

#define VLC_EEXIT         -255                             /* Program exited */
#define VLC_EGENERIC      -666                              /* Generic error */

/*****************************************************************************
 * Booleans
 *****************************************************************************/
#define VLC_FALSE 0
#define VLC_TRUE  1

/*****************************************************************************
 * Playlist
 *****************************************************************************/

/* Used by playlist_Add */
#define PLAYLIST_INSERT          0x0001
#define PLAYLIST_REPLACE         0x0002
#define PLAYLIST_APPEND          0x0004
#define PLAYLIST_GO              0x0008
#define PLAYLIST_CHECK_INSERT    0x0010

#define PLAYLIST_END           -666

/** Playlist commands */
typedef enum {
    PLAYLIST_PLAY,                              /**< Starts playing. No arg. */
    PLAYLIST_PAUSE,                     /**< Toggles playlist pause. No arg. */
    PLAYLIST_STOP,                               /**< Stops playing. No arg. */
    PLAYLIST_SKIP,                               /**< Skip X items and play. */
    PLAYLIST_GOTO,                                       /**< Goto Xth item. */
    PLAYLIST_MODE                                /**< Set playlist mode. ??? */
} playlist_command_t;

/*****************************************************************************
 * Required internal headers
 *****************************************************************************/
#if defined( __VLC__ )
#   include "vlc_common.h"
#endif

/*****************************************************************************
 * Exported libvlc API
 *****************************************************************************/
char const * VLC_Version ( void );
char const * VLC_Error   ( int );

int     VLC_Create       ( void );
int     VLC_Init         ( int, int, char *[] );
int     VLC_Die          ( int );
int     VLC_Destroy      ( int );

int     VLC_Set          ( int, char const *, vlc_value_t );
int     VLC_Get          ( int, char const *, vlc_value_t * );
int     VLC_AddIntf      ( int, char const *, vlc_bool_t );
int     VLC_AddTarget    ( int, char const *, const char **, int, int, int );

int     VLC_Play         ( int );
int     VLC_Pause        ( int );
int     VLC_Stop         ( int );
int     VLC_FullScreen   ( int );

# ifdef __cplusplus
}
# endif

#endif /* <vlc/vlc.h> */
