/*******************************************************************************
* http.cpp: 
* 
* Actually a Web variant on telnet.cpp
* Runs it on port 9997 or wherever vls.cfg says.
* Type in: http://localhost:9997/browse?name=bill?command=browse?user=bozo?password=bozo
*
* and see what it does, or better yet, use a form for
* POST input.
*
* Now accepts cookies and seems to run the commands.
*
* To install, put in src/server/http{.cpp,.h}
*
* Then, everyplace that telnet/Telnet/TELNET
* appear in admin.{cpp,h}, copy to http/Http/HTTP
*
* Add src/server/http.cpp to the Makefile
*
* In vls.cfg, add a section:
*
* # Http Administration
* BEGIN "Http"
*   #  Domain        = "Inet6"              # Inet4 or Inet6
*   LocalPort     = "9997"                # Port to use for that purpose
* END
*
*
* Requires small change in buffers.h:
*
*   inline char* GetContent() const;
*
* and buffers.cpp:
*
*   template <class T> char* C_Buffer<T>::GetContent() const
*   {
*     return (char*)m_aData;
*   }
*
* Bill Eldridge - Radio Free Asia (bill@rfa.org) - 2002/06/05
* 
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: telnet.cpp,v 1.5 2002/03/25 14:49:33 bozo Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
* Informations on the Http protocol can be found in RFC 854 to 861 and also
* RFC 1184 for linemodes
*
*******************************************************************************/



//------------------------------------------------------------------------------
// Preamble
//------------------------------------------------------------------------------
#include "../core/defs.h"

#include <ctype.h>
#include <stdio.h>
#include <time.h>

#include "config.h"
#include "../core/core.h"
#include "../core/network.h"
#include "request.h"
#include "admin.h"
#include "http.h"


#include "../core/network.cpp"


//------------------------------------------------------------------------------
// Http interface
//------------------------------------------------------------------------------
//#define WELCOME         "Videolan Server Administration System"
#define WELCOME         ""
//#define LOGIN           "Login: "
#define LOGIN           ""
//#define PASSWD          "Password: "
#define PASSWD          ""
//#define PROMPT          "vls> "
#define PROMPT          ""


//------------------------------------------------------------------------------
// Http protocol constants
//------------------------------------------------------------------------------
#define IAC     255             // Interpret as command
#define DONT    254             // You are not to use option
#define DO      253             // Please use option
#define WONT    252             // I won't use option
#define WILL    251             // I will use option
#define EL      248             // Erase the current line

#define TELOPT_ECHO     1       // Echo
#define TELOPT_SGA      3       // Suppress go ahead
#define TELOPT_OUTMRK   27      // Output marking
#define TELOPT_LINEMODE 34      // Linemode option

#define KEY_UP          65      // 
#define KEY_DOWN        66      // 
#define KEY_LEFT        67      // 
#define KEY_RIGHT       68      //


//------------------------------------------------------------------------------
// Http module definitions
//------------------------------------------------------------------------------
#define CONFIG_MODE             1
#define CONTROL_MODE            2
#define INTERACTIVE_MODE        3

#define INIT_PHASE              1
#define LOGIN_PHASE             2
#define PASSWD_PHASE            3
#define COMMAND_PHASE           4

#define HISTORY_SIZE            20

#include <stdio.h>
#include <string>
#include <iostream>
#include <vector>
#include <map>


void Tokenize(const string& str,
                      vector<string>& tokens,
                      const string& delimiters = " ")
{
    // Taken from http://www.tldp.org/HOWTO/C++Programming-HOWTO-7.html#ss7.2

    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos     = str.find_first_of(delimiters, lastPos);

    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}


/*******************************************************************************
* E_Http exception
********************************************************************************
*
*******************************************************************************/
E_Http::E_Http(const C_String& strMsg) : E_Exception(GEN_ERR, strMsg)
{
}

E_Http::E_Http(const C_String& strMsg, const E_Exception& e) :
             E_Exception(GEN_ERR, strMsg, e)
{
}


/*******************************************************************************
* C_HttpOptions class
********************************************************************************
* Manage the configuration of the 2 NVT through http negociation
* Very basic at that time, is to be completly rewritten
*******************************************************************************/

//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_Buffer<byte> C_HttpOptions::Request(byte bAction, byte bOption)
{
  C_Buffer<byte> cAnswer(3);
  cAnswer.SetSize(3);
  cAnswer[0] = IAC;
  cAnswer[1] = bAction;
  cAnswer[2] = bOption;
  
  //m_cPendingRequests.PushEnd(new C_Buffer<byte>(cAnswer));

  return cAnswer;
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_Buffer<byte> C_HttpOptions::Answer(const C_Buffer<byte>& cRequest)
{
  ASSERT(cRequest.GetSize() == 3);
  
  C_Buffer<byte> cAnswer(3);
  cAnswer.SetSize(0);
  
  //  cAnswer.SetSize(3);
  //  cAnswer[0] = IAC;
  //  cAnswer[2] = cRequest[3];

  return cAnswer;
}


//------------------------------------------------------------------------------
//
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
int C_HttpOptions::GetOptionStatus()
{
  return YES;
}





/*******************************************************************************
* C_HttpCmdLine class
********************************************************************************
* Manage a http command line
*******************************************************************************/

//------------------------------------------------------------------------------
// Constructor
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_HttpCmdLine::C_HttpCmdLine() : m_cCurrent(m_cHistory.CreateIterator())
{
  m_iPosInLine = 0;
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_String C_HttpCmdLine::Append(byte bByte)
{
  C_String cResult;

  switch(bByte)
  {
    case 0x7F:
    {
      if(m_strLine.Length() > 0)
      {
        m_strLine = m_strLine.SubString(0, m_strLine.Length()-1);
        cResult += "\b\e[P";
      }
      break;
    }
    default:
    {
      if(bByte != '\n' && bByte != '\0')
      {
        m_strLine += (char)bByte;
        cResult += (char)bByte;
      }
    }
  }
  
  return cResult;
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_Buffer<byte> C_HttpCmdLine::Edit(const C_Buffer<byte>& cCmd)
{
  ASSERT(cCmd.GetSize() == 3);
  ASSERT(cCmd[0] = TELOPT_OUTMRK);

  C_String strResult;

  switch(cCmd[2])
  {
    case KEY_UP:
    {
      if(m_cCurrent.HasNext())
      {
         strResult = *m_cCurrent.GetNext();
      }
      break;
    }
    case KEY_DOWN:
    {
      if(m_cCurrent.HasPrevious())
      {
        strResult = *m_cCurrent.GetPrevious();
      }
      break;
    }
  }

  if(strResult != "")
  {
    StartNewLine();
    m_strLine = strResult;
  }

  return /*EL + strResult*/C_Buffer<byte>(0);
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_String C_HttpCmdLine::GetCmdLine()
{
  // Strip line
  C_String strResult = m_strLine.Strip(" \t");
  return strResult;
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_HttpCmdLine::StartNewLine()
{
  // Store current line if not empty
  C_String strLine = GetCmdLine();
  if(strLine.Length() > 0)
  {
    m_cHistory.PushStart(new C_String(strLine));
    // To do: removal of old commands
  }
  
  // Reset command history
  m_cCurrent.Reset();

  // Empty current line
  m_strLine = "";
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_HttpCmdLine::DropLine()
{
  m_strLine = "";
}




/*******************************************************************************
* C_HttpSession class
********************************************************************************
* 
* 
*******************************************************************************/

//------------------------------------------------------------------------------
// Constructor
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_HttpSession::C_HttpSession(C_Socket* pConnection, void* pAdmin) :
                      C_AdminSession((C_Admin*)pAdmin),
                      m_strPeerName("[Unknown]"), m_cStream(pConnection),
                      m_cBuffer(3)
{
  ASSERT(pConnection);

  m_pConnection = pConnection;
  
  // Starting mode
  m_iPhase = INIT_PHASE;
  m_iMode = INTERACTIVE_MODE;
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_HttpSession::OnInit()
{
  // Actual initialisation is done internally in small pieces cause it could
  // block the entire server if done in one single step. For now just send
  // the welcome message
  //m_cStream << "\r\n" << WELCOME << "\r\n\r\n";

  // Transmission parameters: to be able to deal with all clients, editing is
  // done on the server
  //m_cStream << m_cOptions.Request(WILL, TELOPT_ECHO);
  //m_cStream << m_cOptions.Request(WILL, TELOPT_SGA);
  //m_cStream << m_cOptions.Request(DONT, TELOPT_LINEMODE);

  //m_cStream << LOGIN;
  //m_iPhase = LOGIN_PHASE;
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_HttpSession::OnClose()
{
  try
  {
    // Send a goodby message if possible
    //if(m_cStream.GetState() == STREAM_READY)
      //m_cStream << "\r\nClosing connection" << "\r\n";

    // Close the connection
    m_pConnection->Close();
  }
  catch(E_Exception e)
  {
    throw E_Http("Unable to close connection with "+m_strPeerName, e);
  }
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_HttpSession::ProcessData()
{
    vector<string> headlines;
    vector<string> headtokens;
    vector<string> headattrs;
    vector<string> headattr;
    vector<string> envattr;
    vector<string> postlines;
    vector<string> posttokens;
    vector<string> postattrs;
    vector<string> postattr;
    vector<string> cookattr;
    string command,path,fullpath,http,cookie;
    char *p,*q, *s;
    string user="";
    string password="";
    string response;
    string method;
    string inPost;
    int contentlength;
    string problem;
    map<string,string> headmap,postmap,envmap;
    map<string,string>::iterator iter;
    
    C_Buffer<byte> cData(2000);
    unsigned int iPos = 0;
    unsigned int uiSize;
    int iSize;


  try
  {
    // First get the data from the network
    m_cStream >> cData;

    cout << "Size: " << cData.GetSize() << endl;
    //iSize = cData.GetSize();
    string inData(cData.GetContent());
    iSize = strlen(inData.c_str());
    //iSize = (int) inData.size();  // Why are these two different?
    if (iSize <=13)
      throw E_Http("Too little data for valid HTTP request");
    else if (inData.substr(0,3) == "GET") {
      envmap.insert(pair<string,string>("method","GET"));
    }
    else if (inData.substr(0,4) == "POST") {
      envmap.insert(pair<string,string>("method","POST"));
      cout << "iSize: " << iSize << endl; 
      cout << "inData: " << inData << endl; 
    }
    else throw E_Http("Bad HTTP method");

    s=(char*)inData.c_str();
    q=s;

    if (envmap["method"] == "POST") { // Need to find end of header/start of data
                            // C++ command to find "\n\r\n" or "\n\n"?
        cout << "Envmap says POST method" << endl;
        while (1) {
            cout << ".";
            p=strchr(q,'\n');

            if (!p || p-s == iSize )
                throw E_Http("Incomplete POST header");

            if (p-s < iSize && (p+1)[0] == '\n' ) {
                if ( p+2 -s  <= iSize) {
                    //q=p+2;
                    inPost = p+2;
                    inData = inData.substr(0,p+2-s);
                    break;
                }
                else {
                    throw E_Http("No POST data");
                }
            }

            if (p-s <= iSize-1 && (p+1)[0] == '\r' || (p+2)[0] == '\n' ) {
                if ( p+3-s <= iSize) {
                    //q=p+3;
                    inPost = p+3;
                    inData = inData.substr(0,p+3-s);
                    break;
                }
                else {
                    throw E_Http("No POST data");
                }
            }
            q=p+1;
        }
        cout << endl;
    }

    Tokenize(inData, headlines, "\n");
    
    Tokenize(headlines[0],headtokens," " );
    if (headtokens.size() >= 3) {
        envmap.insert(pair<string,string>("http",headtokens[2].substr(0,8)));
        if (envmap["http"] != "HTTP/1.0" && envmap["http"] != "HTTP/1.1") {
                    cout << "Bad HTTP type: " << headtokens[2] << "(length: " << headtokens[2].length() <<  endl;
                    throw E_Http("Bad HTTP type");
        }
        envmap.insert(pair<string,string>("fullpath",headtokens[1]));
        p=strchr(headtokens[1].c_str(),'?');
        if (p) {
            path=envmap["fullpath"].substr(0,p-headtokens[1].c_str());
            Tokenize(p+1,headattrs,"&");

            //iSize = (int) headattrs.size();
            //iSize = (int) headattrs.size();
            iSize =  headattrs.size();
            for (int i=0;i<iSize;i++) {
                Tokenize(headattrs[i],headattr,"=" );
                if (headattr.size() % 2 != 0) 
                    headattr.push_back("");
                if (headattr[headattr.size()-2]=="user") 
                    user=headattr[headattr.size()-1];
                if (headattr[headattr.size()-2]=="password")
                    password=headattr[headattr.size()-1];
                if (headattr[headattr.size()-2]=="command") 
                    command=headattr[headattr.size()-1];
                headmap.insert(pair<string,string>(headattr[headattr.size()-2],headattr[headattr.size()-1]));
            }
        }
    }
    else {
      throw E_Http("Incomplete HTTP request 2");
    }

    //iSize = (int) headlines.size();
    iSize =  headlines.size();
    cout << "Checkpoint iSize: "  << iSize << endl;
    for (int i=1;i<iSize-1;i++) { //Ignore last headline: \n\n
        p=q=(char*)headlines[i].c_str();
        q=strchr(q,':');
        //if (q && q+2-p < headlines[i].size()) {
        if (q) {
            envattr.push_back(headlines[i].substr(0,q-p));
            if (q+2-p < (int) headlines[i].size()) {
              envattr.push_back((string)(q+2));
            }
            envmap.insert(pair<string,string>(envattr[envattr.size()-2],envattr[envattr.size()-1]));
        }
        else {
            continue;
        }

    }
        
    if (envmap.count("Content-Length") == 1) {
        try {
            contentlength=atoi(envattr[envattr.size()-1].c_str());
            cout << "Got content length: " << contentlength << endl;
        }
        catch(E_Exception e) {
            cout << "\n\nCaught exception on content\n\n" << endl;
            problem="Bad Content-Length: ";
            problem += envattr[envattr.size()-1]; 
            //throw E_Http(problem);
            contentlength=0; //will throw 0 length error if POST
        }
    }

    if (envmap.count("Cookie") == 1) {
        cout << "Cookie routine: " << envmap["Cookie"] << endl;
        p=q=(char*)envmap["Cookie"].c_str();
        int start=0;
        int found;
        while(1) {
            found= envmap["Cookie"].find("; ",start);
            cout << "Cookie loop - start: " << start << " found: " <<  found << endl;
            //if (start == found) 
            if (found == -1)
                Tokenize(envmap["Cookie"].substr(start,envmap["Cookie"].size()-1-start),cookattr,"=");
            else if (start > (int)envmap["Cookie"].size())
                break;
            else 
                Tokenize(envmap["Cookie"].substr(start,found-start),cookattr,"=");
            if (cookattr.size() % 2 != 0)
                cookattr.push_back("");
            if (cookattr[cookattr.size()-2]=="user" && user == "") 
                user=cookattr[cookattr.size()-1];
            if (cookattr[cookattr.size()-2]=="password" && password == "") 
                password=cookattr[cookattr.size()-1];
            cout << "...Cookie: " <<cookattr[cookattr.size()-2] << ":" << cookattr[cookattr.size()-1] << " (size" << cookattr[cookattr.size()-1].size() << endl;
            //if (start == found) break;
            if (found == -1) break;
            else start = found+2;
        }
    }
    else cout << "Still no cookie: " << endl;
    if (envmap["method"]=="POST") {
        if (contentlength <= 0) {
            //cout << "inData: \n" << inData << endl;
            throw E_Http("HTTP POST request has no content");
        }
        inPost=inPost.substr(0,contentlength);
        Tokenize(inPost, postlines, "\n");
        Tokenize(postlines[0],postattrs,"&"); // Handle line 0 only
        iSize = (int) postattrs.size();
        for (int i=0;i<iSize;i++) {
            Tokenize(postattrs[i],postattr,"=" );
            if (postattr.size() % 2 != 0)
                postattr.push_back("");
            if (postattr[postattr.size()-2]=="user" && postattr[postattr.size()-1] != "") {
                user=postattr[postattr.size()-1];
            }
            if (postattr[postattr.size()-2]=="password" && postattr[postattr.size()-1] != "") {
                password=postattr[postattr.size()-1];
            }
            if (postattr[postattr.size()-2]=="command") {
                command=postattr[postattr.size()-1];
                int start=0;
                int found = command.find("+",start);
                while (found != -1) {
                    command.replace(found,1," ");
                    start = found+1;
                    found = command.find("+",start);
                }
                cout << "Command: " << command << " (length " << command.size() << endl;
            }
            postmap.insert(pair<string,string>(postattr[postattr.size()-2],postattr[postattr.size()-1]));
            cout << "Postattr: " << postattr[postattr.size()-2] << endl;
        }
    }

    int iRc = Authentificate(user.c_str(),password.c_str());
    
    char cookexp[100];
    string cookie;
    time_t exptime=time(NULL)+24*3600;
    strftime(cookexp,50,"%A, %d-%b-%Y %H:%M:%S GMT",gmtime(&exptime));
    cookie = "Set-Cookie: user=" + user + "; expires=" + cookexp + "\nSet-cookie: password=" + password + "; expires=" + cookexp + "\n";
    cout << "Cookie: " << cookie << endl;

    response="HTTP/1.1 200 OK\nContent-Type: text/html\n";
    response += cookie;
    response += "\n<HTML>\n<HEAD><TITLE>VLS config</TITLE></HEAD>\n<BODY>\n<p>Received your request: </p>\n<p>";
    response += "Method: ";
    response += envmap["method"];
    response += "</p><p>HTTP-type: ";
    response += envmap["http"];
    response += "</p><p>Path: ";
    response += envmap["path"];
    response += "</p><p>Command: ";
    response += envmap["command"];
    response += "</p><pre><p>Attributes:";
    int i;

    if (envmap["method"] == "GET") {
        //map<string,string>::iterator iter = headmap.begin();
        iter = headmap.begin();
        while (iter != headmap.end()) { 
           response += "</p><p>  ";
           response += iter->first;
           response += ": ";
           response += iter->second;
           iter++;
        }
    }
    else {  //POST
        iter = postmap.begin();
        while (iter != postmap.end()) { 
           response += "</p><p>  ";
           response += iter->first;
           response += ": ";
           response += iter->second;
           iter++;
        }
    }
    response += "</p><p>Environment Attributes:";
    iter = envmap.begin();
    while (iter != envmap.end()) { 
       response += "</p><p>  ";
       response += iter->first;
       response += ": ";
       response += iter->second;
       iter++;
    }
    cout << "Just checking" << endl; 
    response += "</p><p>Full request: </p><p>";
    response += inData;
    response += inPost;
    //response += "</pre></p></BODY>\r\n</HTML>\r\n";
    //ExecLogin();
    m_cCmdLine.DropLine();
    //    HandleLine();
    //ExecCommand();

    C_Request cRequest("");
    //char gcom[100] = "start dolby localhost local1  ";
    char gcom[100]; 
    strcpy(gcom, command.c_str());
    C_Answer cAdminAnswer = m_pAdmin->ParseCmdLine(this, gcom, cRequest);


  switch(cAdminAnswer.GetStatus())
  {
  case ADMIN_WELLFORMED_COMMAND:
    //SendAnswer(cAnswer);
    break;

if (!iRc) {
    string response="<HTML><HEAD></HEAD><BODY>Bad login</BODY></HTML>";
    m_cStream << response.c_str();
    throw E_Http("Transaction complete");
}
    
  case ADMIN_COMMAND_NOT_VALID:
    throw E_Http("Unauthorized or Unknown Admin Command");
    break;
  case ADMIN_UNKNOWN_COMMAND:
    throw E_Http("Unauthorized or Unknown Admin Command");
    break;
  case ADMIN_COMMAND_DENIED:
    throw E_Http("Unauthorized or Unknown Admin Command");
    break;
  case ADMIN_EMPTY_COMMAND:
    throw E_Http("Unauthorized or Unknown Admin Command");
    break;
  default:
    ASSERT(false);
    throw E_Http("Unauthorized or Unknown Command");
    break;
  }

    string answer;
    C_Answer cAnswer = m_pAdmin->HandleRequest(cRequest);
    C_List<C_String> cMessageList = cAnswer.GetMessages();

    //C_List<C_String> cMessageList = cAdminAnswer.GetMessages();
    answer += "<p>Answer:</p><p>";
    unsigned int iSize = cMessageList.Size();
    C_String mess;
    for(unsigned int k = 0; k < iSize; k++)
    {
      answer += cMessageList[k].GetString();
      mess=cMessageList[k];
      p=(char*)&mess;
      answer += p;
      answer += "</p>\n<p>";
    }

    C_List<C_Answer> cAnswerList = cAnswer.GetSubAnswers();
    //C_List<C_Answer> cAnswerList = cAdminAnswer.GetSubAnswers();
        
    answer += "<p>    ";

    C_Answer answ("");
    iSize = cAnswerList.Size();
    cout << "iSize: " << iSize << endl;
    for (unsigned int j = 0; j < iSize; j++)
    {
      //p=(char*)cAnswerList[j];
      answ=cAnswerList[j];
      cMessageList = answ.GetMessages();
      for (unsigned int n=0;n<cMessageList.Size();n++) {
        answer += cMessageList[n].GetString();
        answer += "</p><p>    ";
      }
      answer += "</p><p>";
    }
    answer += "</p>";

    response += answer;
    response += "</pre></p></BODY>\r\n</HTML>\r\n";

    m_cStream << response.c_str();
    throw E_Http("Transaction complete");

  }
  catch(E_Stream<C_Socket> e)
  {
    throw E_Http("Connection error", e);
  }
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_HttpSession::HandleLine()
{
  switch(m_iPhase)
  {
    case LOGIN_PHASE:
    {
      // Execute first login phase
      ExecLogin();
      // Drop line since we don't have to remember login
      m_cCmdLine.DropLine();
      break;
    }
    case PASSWD_PHASE:
    {
      // Check login
      ExecLogin();
      // Drop line since we don't have to remember passwd
      m_cCmdLine.DropLine();
      break;
    }
    default:
    {
      ASSERT(m_iPhase == COMMAND_PHASE);
      // Execute command
      ExecCommand();
      // Start a new line
      m_cCmdLine.StartNewLine();
      break;
    }
  }
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_HttpSession::HandleByte(byte bByte)
{
  //printf("char: '%c' (%x)\n", bByte, bByte);
  
  switch(m_iMode)
  {
    case CONFIG_MODE:
    {
      ASSERT(m_cBuffer[0] == IAC);
      unsigned int iSize = m_cBuffer.GetSize();
      m_cBuffer[iSize] = bByte;
      iSize++;
      m_cBuffer.SetSize(iSize);
      if(iSize == 3)
      {
        m_cStream << m_cOptions.Answer(m_cBuffer);
        m_cBuffer.SetSize(0);
        m_iMode = INTERACTIVE_MODE;
      }
      break;
    }
    case CONTROL_MODE:
    {
      ASSERT(m_cBuffer[0] == TELOPT_OUTMRK);
      unsigned int iSize = m_cBuffer.GetSize();
      m_cBuffer[iSize] = bByte;
      iSize++;
      m_cBuffer.SetSize(iSize);
      if(iSize == 3)
      {
        m_cStream << m_cCmdLine.Edit(m_cBuffer);
        m_cBuffer.SetSize(0);
        m_iMode = INTERACTIVE_MODE;
      }
      break;
    }
    default:
    {
      ASSERT(m_iMode == INTERACTIVE_MODE);

      // Drop all characters before init is completed
      int iStatus = m_cOptions.GetOptionStatus();
      if(iStatus == YES)
      {
        // Remote echo      
        C_String cRemoteCmdLine = m_cCmdLine.Append(bByte);
        if(m_iPhase != PASSWD_PHASE)
          m_cStream << cRemoteCmdLine;
      }
      else if(iStatus == NO)
        throw E_Http("Client not supported");
      
      //printf("char: %c\n", bByte);
      break;
    }
  }
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_HttpSession::ExecLogin()
{
  ASSERT(m_iPhase == LOGIN_PHASE || m_iPhase == PASSWD_PHASE);

  if(m_iPhase == LOGIN_PHASE)
  {
    // This is the login which has just been entered
    m_strLogin = m_cCmdLine.GetCmdLine();
    m_strPrompt = PASSWD;
    m_iPhase = PASSWD_PHASE;
  }
  else
  {
    // Login has been entered before, this is the passwd
    C_String strPasswd = m_cCmdLine.GetCmdLine();
    
    // Authentication (to do)
    int iRc = Authentificate(m_strLogin, strPasswd);

    if(!iRc)
    {
      m_strPrompt = m_strLogin + "@" + PROMPT;
      m_iPhase = COMMAND_PHASE;
    }
    else
    {
      m_strPrompt = LOGIN;
      m_iPhase = LOGIN_PHASE;
    }

    m_cStream << "\r\n";
  }
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void C_HttpSession::ExecCommand()
{
  ASSERT(m_iPhase == COMMAND_PHASE);

  C_String strCmd = m_cCmdLine.GetCmdLine();

  C_Request cRequest("");
  C_Answer cAdminAnswer = m_pAdmin->ParseCmdLine(this, strCmd, cRequest);
  switch(cAdminAnswer.GetStatus())
  {
  case ADMIN_WELLFORMED_COMMAND:
    if(cRequest.GetCmd() == "logout")
    {
      throw E_Http("logout requested");
    }
    else
    {
      C_Answer cAnswer = m_pAdmin->HandleRequest(cRequest);
      SendAnswer(cAnswer);
    }
    break;
  case ADMIN_COMMAND_NOT_VALID:
  case ADMIN_UNKNOWN_COMMAND:
  case ADMIN_COMMAND_DENIED:
    //SendAnswer(cAdminAnswer);
    break;
  case ADMIN_EMPTY_COMMAND:
    // Nothing to do
    break;
  default:
    ASSERT(false);
    break;
  }
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
// Send a C_Answer in human readable format
//------------------------------------------------------------------------------
void C_HttpSession::SendAnswer(const C_Answer& cAnswer,
                                 const C_String& strPrefix)
{
  if(cAnswer.GetProvider() != "")
  {
    m_cStream << "\r\n";
    m_cStream << strPrefix + "Provider: " + cAnswer.GetProvider() + "\r\n";

    int iStatus = cAnswer.GetStatus();
    if(iStatus >= 0)
      m_cStream << strPrefix + "Status: " + iStatus + "\r\n";
    else
      m_cStream << strPrefix + "Error: " + iStatus + "\r\n";

    C_List<C_String> cMessageList = cAnswer.GetMessages();
    unsigned int iSize = cMessageList.Size();
    for(unsigned int i = 0; i < iSize; i++)
    {
      m_cStream << strPrefix + "Info: " + cMessageList[i] + "\r\n";
    }

    C_List<C_Answer> cAnswerList = cAnswer.GetSubAnswers();
    iSize = cAnswerList.Size();
    for (unsigned int j = 0; j < iSize; j++)
    {
      SendAnswer(cAnswerList[j], strPrefix+"  ");
    }
  }
}





/*******************************************************************************
* C_Http class
********************************************************************************
* 
*******************************************************************************/

//------------------------------------------------------------------------------
// Constructor
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
C_Http::C_Http(handle hLog, C_Admin *pAdmin) :
              C_ConnectionsHandler<C_HttpSession>(hLog, pAdmin)
{
  ASSERT(hLog);
  ASSERT(pAdmin);

  m_hLog = hLog;
  m_pAdmin = pAdmin;
}


//------------------------------------------------------------------------------
// Initialization
//------------------------------------------------------------------------------
int C_Http::Init()
{
  C_Application* pApp = C_Application::GetApp();
  ASSERT(pApp);

  int iRc = NO_ERR;

  // Get config
  C_String strDomain = pApp->GetSetting("Http.Domain", "Inet4").ToLower();

  int iDomain;
  C_String strDefaultHost;

  if(strDomain == "inet4")
  {
    iDomain = AF_INET;
    strDefaultHost = "0.0.0.0";
  }
#ifdef HAVE_IPV6
  else if(strDomain == "inet6")
  {
    iDomain = AF_INET6;
    strDefaultHost = "0::0";
  }
#endif
  else
  {
    Log(m_hLog, LOG_ERROR, "Unknown domain:\n" + strDomain);
    iRc = GEN_ERR;
  }

  if(!iRc)
  {
    C_String strAddr = pApp->GetSetting("Http.LocalAddress", strDefaultHost);
    C_String strPort = pApp->GetSetting("Http.LocalPort", "9997");

    // Init the socket
    try
    {
      C_ConnectionsHandler<C_HttpSession>::Init(iDomain, strAddr, strPort);
    }
    catch(E_Exception e)
    {
      Log(m_hLog, LOG_ERROR,
          "Http server initialisation failed:\n" + e.Dump());
      iRc = GEN_ERR;
    }
  }
  
  if(!iRc)
    Log(m_hLog, LOG_NOTE, "Http server initialised");

  return iRc;
}


//------------------------------------------------------------------------------
// Execution
//------------------------------------------------------------------------------
int C_Http::Run()
{
  int iRc = NO_ERR;

  try
  {
    C_ConnectionsHandler<C_HttpSession>::Run();
  }
  catch(E_Exception e)
  {
    iRc = GEN_ERR;
    Log(m_hLog, LOG_ERROR, "Http server launch failed:\n" + e.Dump());
  }

  return iRc;
}


//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
int C_Http::Stop()
{
  int iRc = NO_ERR;

  try
  {
    C_ConnectionsHandler<C_HttpSession>::Stop();
  }
  catch(E_Exception e)
  {
    Log(m_hLog, LOG_ERROR, "Could not stop http server:\n" + e.Dump());
    iRc = GEN_ERR;
  }

  if(!iRc)
    Log(m_hLog, LOG_NOTE, "Http server stopped");

  return iRc;
}


//------------------------------------------------------------------------------
// Destruction
//------------------------------------------------------------------------------
int C_Http::Destroy()
{  
  int iRc = NO_ERR;

  try
  {
    C_ConnectionsHandler<C_HttpSession>::Destroy();
  }
  catch(E_Exception e)
  {
    Log(m_hLog, LOG_ERROR, "Error during http server destruction:\n" + e.Dump());
    iRc = GEN_ERR;
  }

  if(!iRc)
    Log(m_hLog, LOG_NOTE, "Http server destroyed");

  return iRc;
}

